# About BrutalWiki

As of 2021, the days when every web nerd made their own pet wiki engine for fun are past. BrutalWiki is a throwback. Think of it as a toy or art piece.

Since you're still reading, here are the technical details.

BrutalWiki is a wiki engine written in PHP, with some unique traits:

* Trying to follow Brutalist web design principles.
* It uses rocket links throughout, making for a very distinct authorial voice.
* The database is contained in a single JSON file that can be manipulated with many 3rd-party tools; that means you can only have so much text on any one wiki, but backups become very easy, and you are never locked in.

Otherwise, BrutalWiki is geared towards personal use. It tries to be somewhat robust and secure, but isn't exactly industrial-strength.

## Features

BrutalWiki has a carefully chosen set of features, in order to limit scope and keep the project manageable:

* Single PHP script; the base edition is only 200 lines of code!
* Database kept in a single JSON file for easy backup and 3rd-party access.
* Wiki syntax that can be rendered through simple text substitution.

The usual conveniences are also available:

* Password-based security, mostly to prevent spam;
* a decent set of configuration options;
* custom stylesheet, logo and icon;
* preview button, recent changes and summaries;
* custom footer and navigation menu;
* page search, page index and statistics;
* error 404 is properly returned for non-existent pages.

On top of that there are some extra features:

* custom syntax and actions can be easily added in config;
* the wiki can be set to read-only mode with an option.

More are planned and will be added as time allows.

## Installation

BrutalWiki requires a web server with PHP 8.2 and the JSON extension installed. Versions 7.3 / 7.4 should still work, but aren't supported.

Installing BrutalWiki goes like this:

* Copy wiki.php where you want it on the web server; you can rename this file.
* Rename wikiconf-sample.php to wikiconf.php and copy it next to the main script. Uncomment the desired options as exemplified in the file and change as needed.
* Visit your new wiki. You should see a default homepage, because the database file doesn't exist yet. Click on Edit This Page, make some changes and save.

This should work out of the box on typical shared hosts. If not, see below.

The first time you do this, the web server needs write permissions to the directory where the database file is kept. After that, it only needs write permissions to the database file itself.

For security, you should change the name and/or location of the database file, and set a custom password.

## A little history

Initial development took place in 2021-2022, but then everyone upgraded to PHP 8 and BrutalWiki stopped working. Lacking the bandwidth to deal with it, I shelved the project for three years. But due to a fan getting in touch (thanks, Pete!) now it's back! 

## For programmers

The file wiki-base.php contains the Base Edition, a 6K, 200-line PHP script that only does the absolute minimum it needs to be called a wiki: paragraphs, links, viewing and editing. The point isn't minimalism, but to establish a baseline and have a solid foundation to build upon. Even this edition tries to be somewhat robust / secure, and has some niceties like a default homepage to help newcomers or stylesheet support.

The full edition was refactored since; in particular, function names changed.

## License and support

BrutalWiki is free and open source software under the Artistic License 2.0; see the included file for more details. Logo and stylesheets are CC-BY-SA.

The easiest way to contact me is via Mastodon, as [@felix@wandering.shop][1]. I'd like to hear from you anyway, but if you have any problems, it's best to open an issue [on Codeberg][2].

[1]: https://wandering.shop/@felix
[2]: https://codeberg.org/nosycat/brutalwiki
