# BrutalWiki option reference

BrutalWiki supports a range of configuration options. The recommended way to set them is creating a file named wikiconf.php in the same directory as the main script, and define the constants you want in it. This file should look like:

```
<?php
define('TIMEZONE', 'Europe/Bucharest');
define('HOMEPAGE', 'About');
?>
```

You can, of course, simply change the main script instead, but you know the drill: you'll lose the changes if you upgrade.

The base edition supports the following options:

* TIMEZONE (default: UTC) just what it says on the tin.
* SITENAME (default: BrutalWiki) also self-explanatory.
* HOMEPAGE (default: Homepage) default page to show.
* TEMPLATE (default: N/A) path to a CSS file to use.
* DATETIME (default: d M Y, H:i T) date / time format.
* DATABASE (default: wiki.json) where to keep the data.
* PASSWORD (default: wikiwikiweb) password for changes.

For security, you should always change the last two options.

The full edition supports a few more:

* MAINMENU (default: Menubar) a page to use for the menu.
* PAGEFOOT (default: Footer) a page to put in the footer.
* VIEWPORT (default: N/A) value of the meta-viewport.
* LOGO_URL (default: N/A) path to a logo for the site.
* ICON_URL (default: N/A) path to an icon for the site.
* DATEONLY (default: d F Y) format for dates with no time.
* RC_COUNT (default: 50) how many recent changes to show.
* READ_ONLY (default: false) make true to disable editing.

Ideally there should be few options, but that's often hard.
