# Security and limitations of BrutalWiki

BrutalWiki 1.0 beta has been checked with a [fuzzer][], for what it's worth, and doesn't seem to have obvious security issues.

[fuzzer]: https://wapiti.sourceforge.io/ "Wapiti vulnerability scanner"

As of version 1.5.1, BrutalWiki has a simple throttling system. It should slow down a potential attacker trying to brute-force the password, but it's not very smart. You should probably treat it more like a simple anti-spam measure than proper authentication.

Conversely, the database file can be given a hard-to-guess name, or even stored outside the web server's document root.

Since the whole database is loaded in memory for every request, there's a practical limit to how much data can be stored in any one BrutalWiki installation. This limit is probably a few megabytes on typical web server setups.

For the same reason, there's no page versioning, so the only defense against spam or errors is to keep backups.

You can of course share the password with other people, but without page versioning or any conflict resolution mechanism data loss can and will happen. See above.
