# About JourNote

JourNote is a *proof of concept* journal app with a text user interface and a couple of goals:

- to illustrate creating a minimal app of this type (in Python);
- to explore the use of `dialog` for a day-to-day tool of moderate complexity.

The name is pronounced like in French.

As of January 2026, JourNote is back after a hiatus; documentation is only now catching up.

## Requirements

- Python 3.5 or newer
- `dialog` (tested with v1.3)
- [optional] `grep` (for the search feature)

## Features

- [X] Use external editor if set, else the `dialog` edit box.
- [X] Works in any given directory (current one by default).
- [X] Create journal files by day, week or month.
- [X] Pick file extension for journal files (plain text / Markdown).
- [X] Configurable number of entries in listings.

### To do

- [X] Improve workflow for Recent and Search.
- [X] Command-line options.
- [X] Man page.

## Usage

JourNote works with plain text files stored in a directory of your choice (see below). You're free to write whatever you want in these files, and to handle them outside the application.

Normally JourNote creates one file per day, and another for quick notes, all named accordingly. Entries can be listed or searched from within the application; older files can be moved to an archive directory.

To achieve this, JourNote uses a TUI (text user interface). All available commands are shown in the main menu.

## Configuration

### Environment variables

- EDITOR sets the text editor to use (default: internal)
- VISUAL is a fallback option for `EDITOR`
- JNDIR sets the working directory (default: config base dir)
- XDG_CONFIG_HOME is used to find the config base dir

### Config file

JourNote has some options that can be set. These are saved to a file in the working directory called `journote.ini`, with contents along these lines:

```ini
[JourNote]
file_ext = .txt
file_limit = 30
# See `man strftime` for details.
date_format = %Y-%m-%d
# Either 0 - Sunday, 1 - Monday... or else Su, Mo, Tu and so on.
week_start = Mo
```

You can create and maintain the config file manually, but there's a better way.

### Option menu

As of version 1.0 beta, JourNote includes an option menu. It offers less freedom than manually editing the config file, but should be easier to use.

Remember to save if you want your configuration changes to be preserved.

## License and support

JourNote is open source under the MIT License. See source code for details.

Feedback is welcome. I can be usually found as [@notimetoplay@elekk.xyz][M] on Mastodon, or else in the [#ctrl-c channel of tilde.chat][IRC] (on IRC).

[M]: https://elekk.xyz/@notimetoplay
[IRC]: ircs://irc.tilde.chat:6697/#ctrl-c

If you have any problems, it's best to open an issue on [Codeberg][].

[Codeberg]: https://codeberg.org/notimetoplay/journote
