# About OutNoted

Just what it says on the tin: OutNoted is an editor for outlines made of one-line notes, inspired by the old Linux/BSD tool `hnb`.

This is my second attempt to make one; my interest in outliners dates back almost five years. The first time I failed however, because outliners are complicated.

The trick, as with many other things, is paring them down to the essence.

## Requirements

OutNoted requires a Python runtime. Python comes preinstalled on the Mac and most Linux distributions; Windows users can get it from the python.org website. You'll also need the Tkinter module, which is bundled with most Windows runtimes and preinstalled on the Mac. On Linux you might need to add it yourself: look in your package manager for something called "tkinter", "python3-tk" or the like.

Python version 3.5 or newer is required as of OutNoted 3.0.1 (sorry).

Minimum screen resolution: 800x600. Recommended: 1024x768.

## Status

This document applies to OutNoted 3.0.1, current as of January 2026. The new version drops compatibility with Python 2.7 and makes a couple of changes:

- There's now a feature to export outlines as tab-indented text; this is a format used by outliners such as TreeLine and My Mind.
- Native file dialogs under X11 now show the missing filters; in addition, use of a deprecated option in Zenity was removed.

Application logic is unchanged from the 2.x series, except for added features. There shouldn't be any new bugs, but please back up your data anyway.

## Features

- Create and edit outlines made of one-line notes.
- Open and save outline formats like Org Mode and OPML.
- Treat any note as a task, link and/or newsfeed.

## Uses

- Bookmark management: don't leave it to the browser!
- Task management: often you don't need much more.
- Planning a book or game, writing dialogue and so on.

## How to use

- Press Ctrl-Insert to add a note, Enter to save.
  - Or just click in the edit line and start typing. 
- Keep typing to add more notes in the same place.
- Use Ctrl-Escape to clear the selection first.
- Press Tab from the edit line to focus the tree.
- Ctrl-E starts editing the selected note.
- Escape on the edit line cancels editing the note.
- Insert adds a child note to the one selected.
- Delete removes the selected note and its children.
- Use the numeric keypad to move notes around.

### Key bindings

(Many bindings have a Command- equivalent for Mac users.)

- Ctrl-N: Start new outline.
- Ctrl-O: Open outline from disk.
- Ctrl-S: Save current outline.
- Ctrl-F: Find text from the beginning.
- Ctrl-G: Find again from the last result.
- Ctrl-1 / Ctrl-2 / Ctrl-3: Set note status.
- F11: Toggle full screen mode.

Other bindings are shown in the menus.

## Remarks

- OutNoted guesses formats based on file extensions to keep it simple.
- OutNoted is best used with mouse and keyboard together.
- If you add notes while a search is active, Find Again will skip them.
- When opening org files, only headings are recognized!
  - Seriously, OutNoted isn't a proper org file editor, sorry. 

## Wishlist

- Insert / extract subtrees.
- Support more metadata / file properties.
- Change note color depending on link or status.

## License and support

OutNoted is open source under the MIT license. See source code for details.

You can usually find me on IRC, in the #ctrl-c channel of tilde.chat, or else as @notimetoplay on the elekk.xyz Mastodon instance. Would love to hear from you.
